#!/bin/sh
PLUGIN=IntegrateFX
cd "$(dirname "$0")"

# Check for common errors.
whoami | grep root > /dev/null   && echo "This script should not be run as root." && exit 1
! which zenity > /dev/null       && echo "Missing required dependency 'zenity'."  && exit 1
ldd plug2.dat | grep "not found" && echo "Missing required library dependency."   && exit 1

# Decide where to install.
clap_dir=$(echo "$CLAP_PATH" | sed 's/:.*//')
clap_dir=${clap_dir:-$HOME/.clap}

# Install the standalone application.
if [ -f plug1.dat ]; then
	echo "Installing the standalone application to $HOME/.local/share"
	mkdir -p "$HOME/.local/share/nakst"
	mkdir -p "$HOME/.local/share/applications"
	cp plug1.dat "$HOME/.local/share/nakst/$PLUGIN"
	cp plug3.dat "$HOME/.local/share/applications/$PLUGIN.desktop"
	printf "Name=$PLUGIN\n" >> "$HOME/.local/share/applications/$PLUGIN.desktop"
	printf "Exec=$HOME/.local/share/nakst/$PLUGIN\n" >> "$HOME/.local/share/applications/$PLUGIN.desktop"
fi

# Install the CLAP plugin.
echo "Installing the CLAP plugin to $clap_dir/nakst/$PLUGIN.clap"
mkdir -p "$clap_dir/nakst"
cp plug2.dat "$clap_dir/nakst/$PLUGIN.clap"

cat ~/.config/NakstAudioPlugins.ini | grep HasAnyPaidPlugins || printf "\n[generic]\nHasAnyPaidPlugins=1\n" >> ~/.config/NakstAudioPlugins.ini
