#!/bin/sh
PLUGIN=Integrate
cd "$(dirname "$0")"

dd if=plug.dat of=plug1.dat iflag=skip_bytes,count_bytes oflag=append status=none conv=notrunc skip=0 count=26624848
md5sum plug1.dat | grep f67623917bc9990e15cca811790fa5d9 > /dev/null || echo plugin database corrupt
dd if=plug.dat of=plug2.dat iflag=skip_bytes,count_bytes oflag=append status=none conv=notrunc skip=26624848 count=1189608
dd if=plug.dat of=plug2.dat iflag=skip_bytes,count_bytes oflag=append status=none conv=notrunc skip=1124608 count=17893224
dd if=plug.dat of=plug2.dat iflag=skip_bytes,count_bytes oflag=append status=none conv=notrunc skip=27814456 count=3005
dd if=plug.dat of=plug2.dat iflag=skip_bytes,count_bytes oflag=append status=none conv=notrunc skip=19017984 count=1039834
dd if=plug.dat of=plug2.dat iflag=skip_bytes,count_bytes oflag=append status=none conv=notrunc skip=27817461 count=518825
dd if=plug.dat of=plug2.dat iflag=skip_bytes,count_bytes oflag=append status=none conv=notrunc skip=20684800 count=4424
dd if=plug.dat of=plug2.dat iflag=skip_bytes,count_bytes oflag=append status=none conv=notrunc skip=28336286 count=103736
dd if=plug.dat of=plug2.dat iflag=skip_bytes,count_bytes oflag=append status=none conv=notrunc skip=20684800 count=4424
dd if=plug.dat of=plug2.dat iflag=skip_bytes,count_bytes oflag=append status=none conv=notrunc skip=28440022 count=112047
dd if=plug.dat of=plug2.dat iflag=skip_bytes,count_bytes oflag=append status=none conv=notrunc skip=20799488 count=7912
dd if=plug.dat of=plug2.dat iflag=skip_bytes,count_bytes oflag=append status=none conv=notrunc skip=28552069 count=7513
dd if=plug.dat of=plug2.dat iflag=skip_bytes,count_bytes oflag=append status=none conv=notrunc skip=20814848 count=5520
dd if=plug.dat of=plug2.dat iflag=skip_bytes,count_bytes oflag=append status=none conv=notrunc skip=28559582 count=192
dd if=plug.dat of=plug2.dat iflag=skip_bytes,count_bytes oflag=append status=none conv=notrunc skip=20820480 count=4866352
dd if=plug.dat of=plug2.dat iflag=skip_bytes,count_bytes oflag=append status=none conv=notrunc skip=28559774 count=10200
dd if=plug.dat of=plug2.dat iflag=skip_bytes,count_bytes oflag=append status=none conv=notrunc skip=25699584 count=122572
dd if=plug.dat of=plug2.dat iflag=skip_bytes,count_bytes oflag=append status=none conv=notrunc skip=28569974 count=11036
dd if=plug.dat of=plug2.dat iflag=skip_bytes,count_bytes oflag=append status=none conv=notrunc skip=25832704 count=12175
dd if=plug.dat of=plug2.dat iflag=skip_bytes,count_bytes oflag=append status=none conv=notrunc skip=28581010 count=768137
dd if=plug.dat of=plug2.dat iflag=skip_bytes,count_bytes oflag=append status=none conv=notrunc skip=26609920 count=12416
dd if=plug.dat of=plug2.dat iflag=skip_bytes,count_bytes oflag=append status=none conv=notrunc skip=29349147 count=2432
md5sum plug2.dat | grep bd3b2bed94826f0e897c9e6e4786981d > /dev/null || echo plugin database corrupt
dd if=plug.dat of=plug3.dat iflag=skip_bytes,count_bytes oflag=append status=none conv=notrunc skip=29351579 count=91
md5sum plug3.dat | grep 41ad527eef2d042dada68ce8d1e96be4 > /dev/null || echo plugin database corrupt
dd if=plug.dat of=plug4.dat iflag=skip_bytes,count_bytes oflag=append status=none conv=notrunc skip=29351670 count=1064431
dd if=plug.dat of=plug4.dat iflag=skip_bytes,count_bytes oflag=append status=none conv=notrunc skip=9782528 count=25923
dd if=plug.dat of=plug4.dat iflag=skip_bytes,count_bytes oflag=append status=none conv=notrunc skip=30416101 count=31
dd if=plug.dat of=plug4.dat iflag=skip_bytes,count_bytes oflag=append status=none conv=notrunc skip=10515968 count=5502490
dd if=plug.dat of=plug4.dat iflag=skip_bytes,count_bytes oflag=append status=none conv=notrunc skip=30416132 count=70
dd if=plug.dat of=plug4.dat iflag=skip_bytes,count_bytes oflag=append status=none conv=notrunc skip=6672128 count=9100
dd if=plug.dat of=plug4.dat iflag=skip_bytes,count_bytes oflag=append status=none conv=notrunc skip=30416202 count=38
dd if=plug.dat of=plug4.dat iflag=skip_bytes,count_bytes oflag=append status=none conv=notrunc skip=16187904 count=1998020
dd if=plug.dat of=plug4.dat iflag=skip_bytes,count_bytes oflag=append status=none conv=notrunc skip=30416240 count=253
dd if=plug.dat of=plug4.dat iflag=skip_bytes,count_bytes oflag=append status=none conv=notrunc skip=16162816 count=10109
dd if=plug.dat of=plug4.dat iflag=skip_bytes,count_bytes oflag=append status=none conv=notrunc skip=30416493 count=134
dd if=plug.dat of=plug4.dat iflag=skip_bytes,count_bytes oflag=append status=none conv=notrunc skip=6759936 count=8391
dd if=plug.dat of=plug4.dat iflag=skip_bytes,count_bytes oflag=append status=none conv=notrunc skip=30416627 count=4015
dd if=plug.dat of=plug4.dat iflag=skip_bytes,count_bytes oflag=append status=none conv=notrunc skip=1138944 count=5523974
dd if=plug.dat of=plug4.dat iflag=skip_bytes,count_bytes oflag=append status=none conv=notrunc skip=30420642 count=119
dd if=plug.dat of=plug4.dat iflag=skip_bytes,count_bytes oflag=append status=none conv=notrunc skip=6723584 count=35526
dd if=plug.dat of=plug4.dat iflag=skip_bytes,count_bytes oflag=append status=none conv=notrunc skip=30420761 count=13
dd if=plug.dat of=plug4.dat iflag=skip_bytes,count_bytes oflag=append status=none conv=notrunc skip=6662912 count=9146
dd if=plug.dat of=plug4.dat iflag=skip_bytes,count_bytes oflag=append status=none conv=notrunc skip=30420774 count=94
dd if=plug.dat of=plug4.dat iflag=skip_bytes,count_bytes oflag=append status=none conv=notrunc skip=10397184 count=10090
dd if=plug.dat of=plug4.dat iflag=skip_bytes,count_bytes oflag=append status=none conv=notrunc skip=30420868 count=48
dd if=plug.dat of=plug4.dat iflag=skip_bytes,count_bytes oflag=append status=none conv=notrunc skip=10380288 count=7098
dd if=plug.dat of=plug4.dat iflag=skip_bytes,count_bytes oflag=append status=none conv=notrunc skip=30420916 count=2362
dd if=plug.dat of=plug4.dat iflag=skip_bytes,count_bytes oflag=append status=none conv=notrunc skip=10373120 count=4738
dd if=plug.dat of=plug4.dat iflag=skip_bytes,count_bytes oflag=append status=none conv=notrunc skip=30423278 count=44
dd if=plug.dat of=plug4.dat iflag=skip_bytes,count_bytes oflag=append status=none conv=notrunc skip=10418176 count=32530
dd if=plug.dat of=plug4.dat iflag=skip_bytes,count_bytes oflag=append status=none conv=notrunc skip=30423322 count=44
dd if=plug.dat of=plug4.dat iflag=skip_bytes,count_bytes oflag=append status=none conv=notrunc skip=10418176 count=10813
dd if=plug.dat of=plug4.dat iflag=skip_bytes,count_bytes oflag=append status=none conv=notrunc skip=30423366 count=29
dd if=plug.dat of=plug4.dat iflag=skip_bytes,count_bytes oflag=append status=none conv=notrunc skip=8275456 count=1507071
dd if=plug.dat of=plug4.dat iflag=skip_bytes,count_bytes oflag=append status=none conv=notrunc skip=30423395 count=29
dd if=plug.dat of=plug4.dat iflag=skip_bytes,count_bytes oflag=append status=none conv=notrunc skip=8275456 count=1507071
dd if=plug.dat of=plug4.dat iflag=skip_bytes,count_bytes oflag=append status=none conv=notrunc skip=30423424 count=71
dd if=plug.dat of=plug4.dat iflag=skip_bytes,count_bytes oflag=append status=none conv=notrunc skip=10092800 count=280321
dd if=plug.dat of=plug4.dat iflag=skip_bytes,count_bytes oflag=append status=none conv=notrunc skip=30423495 count=6
dd if=plug.dat of=plug4.dat iflag=skip_bytes,count_bytes oflag=append status=none conv=notrunc skip=9952512 count=280422
dd if=plug.dat of=plug4.dat iflag=skip_bytes,count_bytes oflag=append status=none conv=notrunc skip=30423501 count=52
dd if=plug.dat of=plug4.dat iflag=skip_bytes,count_bytes oflag=append status=none conv=notrunc skip=10503936 count=12001
dd if=plug.dat of=plug4.dat iflag=skip_bytes,count_bytes oflag=append status=none conv=notrunc skip=30423553 count=52
dd if=plug.dat of=plug4.dat iflag=skip_bytes,count_bytes oflag=append status=none conv=notrunc skip=10503936 count=12001
dd if=plug.dat of=plug4.dat iflag=skip_bytes,count_bytes oflag=append status=none conv=notrunc skip=30423605 count=52
dd if=plug.dat of=plug4.dat iflag=skip_bytes,count_bytes oflag=append status=none conv=notrunc skip=10503936 count=12001
dd if=plug.dat of=plug4.dat iflag=skip_bytes,count_bytes oflag=append status=none conv=notrunc skip=30423657 count=52
dd if=plug.dat of=plug4.dat iflag=skip_bytes,count_bytes oflag=append status=none conv=notrunc skip=10503936 count=12001
dd if=plug.dat of=plug4.dat iflag=skip_bytes,count_bytes oflag=append status=none conv=notrunc skip=30423709 count=67
dd if=plug.dat of=plug4.dat iflag=skip_bytes,count_bytes oflag=append status=none conv=notrunc skip=16054528 count=51797
dd if=plug.dat of=plug4.dat iflag=skip_bytes,count_bytes oflag=append status=none conv=notrunc skip=30423776 count=111
dd if=plug.dat of=plug4.dat iflag=skip_bytes,count_bytes oflag=append status=none conv=notrunc skip=16045568 count=8893
dd if=plug.dat of=plug4.dat iflag=skip_bytes,count_bytes oflag=append status=none conv=notrunc skip=30423887 count=111
dd if=plug.dat of=plug4.dat iflag=skip_bytes,count_bytes oflag=append status=none conv=notrunc skip=16045568 count=8893
dd if=plug.dat of=plug4.dat iflag=skip_bytes,count_bytes oflag=append status=none conv=notrunc skip=30423998 count=143
dd if=plug.dat of=plug4.dat iflag=skip_bytes,count_bytes oflag=append status=none conv=notrunc skip=16036608 count=17853
dd if=plug.dat of=plug4.dat iflag=skip_bytes,count_bytes oflag=append status=none conv=notrunc skip=30424141 count=47
dd if=plug.dat of=plug4.dat iflag=skip_bytes,count_bytes oflag=append status=none conv=notrunc skip=1124608 count=14189
dd if=plug.dat of=plug4.dat iflag=skip_bytes,count_bytes oflag=append status=none conv=notrunc skip=30424188 count=53
dd if=plug.dat of=plug4.dat iflag=skip_bytes,count_bytes oflag=append status=none conv=notrunc skip=6691840 count=31625
dd if=plug.dat of=plug4.dat iflag=skip_bytes,count_bytes oflag=append status=none conv=notrunc skip=30424241 count=52
dd if=plug.dat of=plug4.dat iflag=skip_bytes,count_bytes oflag=append status=none conv=notrunc skip=6691840 count=10507
dd if=plug.dat of=plug4.dat iflag=skip_bytes,count_bytes oflag=append status=none conv=notrunc skip=30424293 count=70
dd if=plug.dat of=plug4.dat iflag=skip_bytes,count_bytes oflag=append status=none conv=notrunc skip=10387456 count=9634
dd if=plug.dat of=plug4.dat iflag=skip_bytes,count_bytes oflag=append status=none conv=notrunc skip=30424363 count=134
dd if=plug.dat of=plug4.dat iflag=skip_bytes,count_bytes oflag=append status=none conv=notrunc skip=10460160 count=7566
dd if=plug.dat of=plug4.dat iflag=skip_bytes,count_bytes oflag=append status=none conv=notrunc skip=30424497 count=134
dd if=plug.dat of=plug4.dat iflag=skip_bytes,count_bytes oflag=append status=none conv=notrunc skip=10460160 count=7566
dd if=plug.dat of=plug4.dat iflag=skip_bytes,count_bytes oflag=append status=none conv=notrunc skip=30424631 count=116
dd if=plug.dat of=plug4.dat iflag=skip_bytes,count_bytes oflag=append status=none conv=notrunc skip=16181504 count=6362
dd if=plug.dat of=plug4.dat iflag=skip_bytes,count_bytes oflag=append status=none conv=notrunc skip=30424747 count=1609
dd if=plug.dat of=plug4.dat iflag=skip_bytes,count_bytes oflag=append status=none conv=notrunc skip=16157184 count=5379
dd if=plug.dat of=plug4.dat iflag=skip_bytes,count_bytes oflag=append status=none conv=notrunc skip=30426356 count=7
dd if=plug.dat of=plug4.dat iflag=skip_bytes,count_bytes oflag=append status=none conv=notrunc skip=16157184 count=5379
dd if=plug.dat of=plug4.dat iflag=skip_bytes,count_bytes oflag=append status=none conv=notrunc skip=30426363 count=82
dd if=plug.dat of=plug4.dat iflag=skip_bytes,count_bytes oflag=append status=none conv=notrunc skip=16117760 count=34049
dd if=plug.dat of=plug4.dat iflag=skip_bytes,count_bytes oflag=append status=none conv=notrunc skip=30426445 count=64
dd if=plug.dat of=plug4.dat iflag=skip_bytes,count_bytes oflag=append status=none conv=notrunc skip=16117760 count=11289
dd if=plug.dat of=plug4.dat iflag=skip_bytes,count_bytes oflag=append status=none conv=notrunc skip=30426509 count=311
dd if=plug.dat of=plug4.dat iflag=skip_bytes,count_bytes oflag=append status=none conv=notrunc skip=16172544 count=8843
dd if=plug.dat of=plug4.dat iflag=skip_bytes,count_bytes oflag=append status=none conv=notrunc skip=30426820 count=104
dd if=plug.dat of=plug4.dat iflag=skip_bytes,count_bytes oflag=append status=none conv=notrunc skip=18304512 count=84697
dd if=plug.dat of=plug4.dat iflag=skip_bytes,count_bytes oflag=append status=none conv=notrunc skip=30426924 count=3
dd if=plug.dat of=plug4.dat iflag=skip_bytes,count_bytes oflag=append status=none conv=notrunc skip=18251264 count=31917
dd if=plug.dat of=plug4.dat iflag=skip_bytes,count_bytes oflag=append status=none conv=notrunc skip=30426927 count=37
dd if=plug.dat of=plug4.dat iflag=skip_bytes,count_bytes oflag=append status=none conv=notrunc skip=18185984 count=17078
dd if=plug.dat of=plug4.dat iflag=skip_bytes,count_bytes oflag=append status=none conv=notrunc skip=30426964 count=38
dd if=plug.dat of=plug4.dat iflag=skip_bytes,count_bytes oflag=append status=none conv=notrunc skip=18389248 count=12428
dd if=plug.dat of=plug4.dat iflag=skip_bytes,count_bytes oflag=append status=none conv=notrunc skip=30427002 count=88
dd if=plug.dat of=plug4.dat iflag=skip_bytes,count_bytes oflag=append status=none conv=notrunc skip=18283264 count=21144
dd if=plug.dat of=plug4.dat iflag=skip_bytes,count_bytes oflag=append status=none conv=notrunc skip=30427090 count=1382
dd if=plug.dat of=plug4.dat iflag=skip_bytes,count_bytes oflag=append status=none conv=notrunc skip=18203136 count=11769
dd if=plug.dat of=plug4.dat iflag=skip_bytes,count_bytes oflag=append status=none conv=notrunc skip=30428472 count=205
dd if=plug.dat of=plug4.dat iflag=skip_bytes,count_bytes oflag=append status=none conv=notrunc skip=18430720 count=11545
dd if=plug.dat of=plug4.dat iflag=skip_bytes,count_bytes oflag=append status=none conv=notrunc skip=30428677 count=26
dd if=plug.dat of=plug4.dat iflag=skip_bytes,count_bytes oflag=append status=none conv=notrunc skip=18214912 count=36349
dd if=plug.dat of=plug4.dat iflag=skip_bytes,count_bytes oflag=append status=none conv=notrunc skip=30428703 count=116
dd if=plug.dat of=plug4.dat iflag=skip_bytes,count_bytes oflag=append status=none conv=notrunc skip=18401792 count=27397
dd if=plug.dat of=plug4.dat iflag=skip_bytes,count_bytes oflag=append status=none conv=notrunc skip=30428819 count=2279
dd if=plug.dat of=plug4.dat iflag=skip_bytes,count_bytes oflag=append status=none conv=notrunc skip=18444544 count=1613241
dd if=plug.dat of=plug4.dat iflag=skip_bytes,count_bytes oflag=append status=none conv=notrunc skip=30431098 count=203698
dd if=plug.dat of=plug4.dat iflag=skip_bytes,count_bytes oflag=append status=none conv=notrunc skip=20814848 count=5520
dd if=plug.dat of=plug4.dat iflag=skip_bytes,count_bytes oflag=append status=none conv=notrunc skip=30634796 count=13664
dd if=plug.dat of=plug4.dat iflag=skip_bytes,count_bytes oflag=append status=none conv=notrunc skip=22939904 count=1373199
dd if=plug.dat of=plug4.dat iflag=skip_bytes,count_bytes oflag=append status=none conv=notrunc skip=30648460 count=1361
dd if=plug.dat of=plug4.dat iflag=skip_bytes,count_bytes oflag=append status=none conv=notrunc skip=20822272 count=2114479
dd if=plug.dat of=plug4.dat iflag=skip_bytes,count_bytes oflag=append status=none conv=notrunc skip=30649821 count=753
dd if=plug.dat of=plug4.dat iflag=skip_bytes,count_bytes oflag=append status=none conv=notrunc skip=24313856 count=1373216
dd if=plug.dat of=plug4.dat iflag=skip_bytes,count_bytes oflag=append status=none conv=notrunc skip=30650574 count=14880
dd if=plug.dat of=plug4.dat iflag=skip_bytes,count_bytes oflag=append status=none conv=notrunc skip=25701888 count=11664
dd if=plug.dat of=plug4.dat iflag=skip_bytes,count_bytes oflag=append status=none conv=notrunc skip=30665454 count=3832
dd if=plug.dat of=plug4.dat iflag=skip_bytes,count_bytes oflag=append status=none conv=notrunc skip=25717504 count=27264
dd if=plug.dat of=plug4.dat iflag=skip_bytes,count_bytes oflag=append status=none conv=notrunc skip=30669286 count=1024
dd if=plug.dat of=plug4.dat iflag=skip_bytes,count_bytes oflag=append status=none conv=notrunc skip=25777408 count=11156
dd if=plug.dat of=plug4.dat iflag=skip_bytes,count_bytes oflag=append status=none conv=notrunc skip=30670310 count=668
dd if=plug.dat of=plug4.dat iflag=skip_bytes,count_bytes oflag=append status=none conv=notrunc skip=25789184 count=32664
dd if=plug.dat of=plug4.dat iflag=skip_bytes,count_bytes oflag=append status=none conv=notrunc skip=30670978 count=384
dd if=plug.dat of=plug4.dat iflag=skip_bytes,count_bytes oflag=append status=none conv=notrunc skip=25745152 count=31368
dd if=plug.dat of=plug4.dat iflag=skip_bytes,count_bytes oflag=append status=none conv=notrunc skip=30671362 count=814848
dd if=plug.dat of=plug4.dat iflag=skip_bytes,count_bytes oflag=append status=none conv=notrunc skip=26609920 count=11768
dd if=plug.dat of=plug4.dat iflag=skip_bytes,count_bytes oflag=append status=none conv=notrunc skip=31486210 count=2296
md5sum plug4.dat | grep ef2c4c3ca731d2fff19ab4e0efe19a24 > /dev/null || echo plugin database corrupt
dd if=plug.dat of=plug5.dat iflag=skip_bytes,count_bytes oflag=append status=none conv=notrunc skip=31488506 count=1120551
dd if=plug.dat of=plug5.dat iflag=skip_bytes,count_bytes oflag=append status=none conv=notrunc skip=9782528 count=25923
dd if=plug.dat of=plug5.dat iflag=skip_bytes,count_bytes oflag=append status=none conv=notrunc skip=32609057 count=31
dd if=plug.dat of=plug5.dat iflag=skip_bytes,count_bytes oflag=append status=none conv=notrunc skip=10515968 count=5502490
dd if=plug.dat of=plug5.dat iflag=skip_bytes,count_bytes oflag=append status=none conv=notrunc skip=32609088 count=70
dd if=plug.dat of=plug5.dat iflag=skip_bytes,count_bytes oflag=append status=none conv=notrunc skip=6672128 count=9100
dd if=plug.dat of=plug5.dat iflag=skip_bytes,count_bytes oflag=append status=none conv=notrunc skip=32609158 count=38
dd if=plug.dat of=plug5.dat iflag=skip_bytes,count_bytes oflag=append status=none conv=notrunc skip=16187904 count=1998020
dd if=plug.dat of=plug5.dat iflag=skip_bytes,count_bytes oflag=append status=none conv=notrunc skip=32609196 count=253
dd if=plug.dat of=plug5.dat iflag=skip_bytes,count_bytes oflag=append status=none conv=notrunc skip=16162816 count=10109
dd if=plug.dat of=plug5.dat iflag=skip_bytes,count_bytes oflag=append status=none conv=notrunc skip=32609449 count=134
dd if=plug.dat of=plug5.dat iflag=skip_bytes,count_bytes oflag=append status=none conv=notrunc skip=6759936 count=8391
dd if=plug.dat of=plug5.dat iflag=skip_bytes,count_bytes oflag=append status=none conv=notrunc skip=32609583 count=4015
dd if=plug.dat of=plug5.dat iflag=skip_bytes,count_bytes oflag=append status=none conv=notrunc skip=1138944 count=5523974
dd if=plug.dat of=plug5.dat iflag=skip_bytes,count_bytes oflag=append status=none conv=notrunc skip=32613598 count=119
dd if=plug.dat of=plug5.dat iflag=skip_bytes,count_bytes oflag=append status=none conv=notrunc skip=6723584 count=35526
dd if=plug.dat of=plug5.dat iflag=skip_bytes,count_bytes oflag=append status=none conv=notrunc skip=32613717 count=13
dd if=plug.dat of=plug5.dat iflag=skip_bytes,count_bytes oflag=append status=none conv=notrunc skip=6662912 count=9146
dd if=plug.dat of=plug5.dat iflag=skip_bytes,count_bytes oflag=append status=none conv=notrunc skip=32613730 count=94
dd if=plug.dat of=plug5.dat iflag=skip_bytes,count_bytes oflag=append status=none conv=notrunc skip=10397184 count=10090
dd if=plug.dat of=plug5.dat iflag=skip_bytes,count_bytes oflag=append status=none conv=notrunc skip=32613824 count=48
dd if=plug.dat of=plug5.dat iflag=skip_bytes,count_bytes oflag=append status=none conv=notrunc skip=10380288 count=7098
dd if=plug.dat of=plug5.dat iflag=skip_bytes,count_bytes oflag=append status=none conv=notrunc skip=32613872 count=2362
dd if=plug.dat of=plug5.dat iflag=skip_bytes,count_bytes oflag=append status=none conv=notrunc skip=10373120 count=4738
dd if=plug.dat of=plug5.dat iflag=skip_bytes,count_bytes oflag=append status=none conv=notrunc skip=32616234 count=44
dd if=plug.dat of=plug5.dat iflag=skip_bytes,count_bytes oflag=append status=none conv=notrunc skip=10418176 count=32530
dd if=plug.dat of=plug5.dat iflag=skip_bytes,count_bytes oflag=append status=none conv=notrunc skip=32616278 count=44
dd if=plug.dat of=plug5.dat iflag=skip_bytes,count_bytes oflag=append status=none conv=notrunc skip=10418176 count=10813
dd if=plug.dat of=plug5.dat iflag=skip_bytes,count_bytes oflag=append status=none conv=notrunc skip=32616322 count=29
dd if=plug.dat of=plug5.dat iflag=skip_bytes,count_bytes oflag=append status=none conv=notrunc skip=8275456 count=1507071
dd if=plug.dat of=plug5.dat iflag=skip_bytes,count_bytes oflag=append status=none conv=notrunc skip=32616351 count=29
dd if=plug.dat of=plug5.dat iflag=skip_bytes,count_bytes oflag=append status=none conv=notrunc skip=8275456 count=1507071
dd if=plug.dat of=plug5.dat iflag=skip_bytes,count_bytes oflag=append status=none conv=notrunc skip=32616380 count=71
dd if=plug.dat of=plug5.dat iflag=skip_bytes,count_bytes oflag=append status=none conv=notrunc skip=10092800 count=280321
dd if=plug.dat of=plug5.dat iflag=skip_bytes,count_bytes oflag=append status=none conv=notrunc skip=32616451 count=6
dd if=plug.dat of=plug5.dat iflag=skip_bytes,count_bytes oflag=append status=none conv=notrunc skip=9952512 count=280422
dd if=plug.dat of=plug5.dat iflag=skip_bytes,count_bytes oflag=append status=none conv=notrunc skip=32616457 count=52
dd if=plug.dat of=plug5.dat iflag=skip_bytes,count_bytes oflag=append status=none conv=notrunc skip=10503936 count=12001
dd if=plug.dat of=plug5.dat iflag=skip_bytes,count_bytes oflag=append status=none conv=notrunc skip=32616509 count=52
dd if=plug.dat of=plug5.dat iflag=skip_bytes,count_bytes oflag=append status=none conv=notrunc skip=10503936 count=12001
dd if=plug.dat of=plug5.dat iflag=skip_bytes,count_bytes oflag=append status=none conv=notrunc skip=32616561 count=52
dd if=plug.dat of=plug5.dat iflag=skip_bytes,count_bytes oflag=append status=none conv=notrunc skip=10503936 count=12001
dd if=plug.dat of=plug5.dat iflag=skip_bytes,count_bytes oflag=append status=none conv=notrunc skip=32616613 count=52
dd if=plug.dat of=plug5.dat iflag=skip_bytes,count_bytes oflag=append status=none conv=notrunc skip=10503936 count=12001
dd if=plug.dat of=plug5.dat iflag=skip_bytes,count_bytes oflag=append status=none conv=notrunc skip=32616665 count=67
dd if=plug.dat of=plug5.dat iflag=skip_bytes,count_bytes oflag=append status=none conv=notrunc skip=16054528 count=51797
dd if=plug.dat of=plug5.dat iflag=skip_bytes,count_bytes oflag=append status=none conv=notrunc skip=32616732 count=111
dd if=plug.dat of=plug5.dat iflag=skip_bytes,count_bytes oflag=append status=none conv=notrunc skip=16045568 count=8893
dd if=plug.dat of=plug5.dat iflag=skip_bytes,count_bytes oflag=append status=none conv=notrunc skip=32616843 count=111
dd if=plug.dat of=plug5.dat iflag=skip_bytes,count_bytes oflag=append status=none conv=notrunc skip=16045568 count=8893
dd if=plug.dat of=plug5.dat iflag=skip_bytes,count_bytes oflag=append status=none conv=notrunc skip=32616954 count=143
dd if=plug.dat of=plug5.dat iflag=skip_bytes,count_bytes oflag=append status=none conv=notrunc skip=16036608 count=17853
dd if=plug.dat of=plug5.dat iflag=skip_bytes,count_bytes oflag=append status=none conv=notrunc skip=32617097 count=47
dd if=plug.dat of=plug5.dat iflag=skip_bytes,count_bytes oflag=append status=none conv=notrunc skip=1124608 count=14189
dd if=plug.dat of=plug5.dat iflag=skip_bytes,count_bytes oflag=append status=none conv=notrunc skip=32617144 count=53
dd if=plug.dat of=plug5.dat iflag=skip_bytes,count_bytes oflag=append status=none conv=notrunc skip=6691840 count=31625
dd if=plug.dat of=plug5.dat iflag=skip_bytes,count_bytes oflag=append status=none conv=notrunc skip=32617197 count=52
dd if=plug.dat of=plug5.dat iflag=skip_bytes,count_bytes oflag=append status=none conv=notrunc skip=6691840 count=10507
dd if=plug.dat of=plug5.dat iflag=skip_bytes,count_bytes oflag=append status=none conv=notrunc skip=32617249 count=70
dd if=plug.dat of=plug5.dat iflag=skip_bytes,count_bytes oflag=append status=none conv=notrunc skip=10387456 count=9634
dd if=plug.dat of=plug5.dat iflag=skip_bytes,count_bytes oflag=append status=none conv=notrunc skip=32617319 count=134
dd if=plug.dat of=plug5.dat iflag=skip_bytes,count_bytes oflag=append status=none conv=notrunc skip=10460160 count=7566
dd if=plug.dat of=plug5.dat iflag=skip_bytes,count_bytes oflag=append status=none conv=notrunc skip=32617453 count=134
dd if=plug.dat of=plug5.dat iflag=skip_bytes,count_bytes oflag=append status=none conv=notrunc skip=10460160 count=7566
dd if=plug.dat of=plug5.dat iflag=skip_bytes,count_bytes oflag=append status=none conv=notrunc skip=32617587 count=116
dd if=plug.dat of=plug5.dat iflag=skip_bytes,count_bytes oflag=append status=none conv=notrunc skip=16181504 count=6362
dd if=plug.dat of=plug5.dat iflag=skip_bytes,count_bytes oflag=append status=none conv=notrunc skip=32617703 count=1609
dd if=plug.dat of=plug5.dat iflag=skip_bytes,count_bytes oflag=append status=none conv=notrunc skip=16157184 count=5379
dd if=plug.dat of=plug5.dat iflag=skip_bytes,count_bytes oflag=append status=none conv=notrunc skip=32619312 count=7
dd if=plug.dat of=plug5.dat iflag=skip_bytes,count_bytes oflag=append status=none conv=notrunc skip=16157184 count=5379
dd if=plug.dat of=plug5.dat iflag=skip_bytes,count_bytes oflag=append status=none conv=notrunc skip=32619319 count=82
dd if=plug.dat of=plug5.dat iflag=skip_bytes,count_bytes oflag=append status=none conv=notrunc skip=16117760 count=34049
dd if=plug.dat of=plug5.dat iflag=skip_bytes,count_bytes oflag=append status=none conv=notrunc skip=32619401 count=64
dd if=plug.dat of=plug5.dat iflag=skip_bytes,count_bytes oflag=append status=none conv=notrunc skip=16117760 count=11289
dd if=plug.dat of=plug5.dat iflag=skip_bytes,count_bytes oflag=append status=none conv=notrunc skip=32619465 count=311
dd if=plug.dat of=plug5.dat iflag=skip_bytes,count_bytes oflag=append status=none conv=notrunc skip=16172544 count=8843
dd if=plug.dat of=plug5.dat iflag=skip_bytes,count_bytes oflag=append status=none conv=notrunc skip=32619776 count=104
dd if=plug.dat of=plug5.dat iflag=skip_bytes,count_bytes oflag=append status=none conv=notrunc skip=18304512 count=84697
dd if=plug.dat of=plug5.dat iflag=skip_bytes,count_bytes oflag=append status=none conv=notrunc skip=32619880 count=3
dd if=plug.dat of=plug5.dat iflag=skip_bytes,count_bytes oflag=append status=none conv=notrunc skip=18251264 count=31917
dd if=plug.dat of=plug5.dat iflag=skip_bytes,count_bytes oflag=append status=none conv=notrunc skip=32619883 count=37
dd if=plug.dat of=plug5.dat iflag=skip_bytes,count_bytes oflag=append status=none conv=notrunc skip=18185984 count=17078
dd if=plug.dat of=plug5.dat iflag=skip_bytes,count_bytes oflag=append status=none conv=notrunc skip=32619920 count=38
dd if=plug.dat of=plug5.dat iflag=skip_bytes,count_bytes oflag=append status=none conv=notrunc skip=18389248 count=12428
dd if=plug.dat of=plug5.dat iflag=skip_bytes,count_bytes oflag=append status=none conv=notrunc skip=32619958 count=88
dd if=plug.dat of=plug5.dat iflag=skip_bytes,count_bytes oflag=append status=none conv=notrunc skip=18283264 count=21144
dd if=plug.dat of=plug5.dat iflag=skip_bytes,count_bytes oflag=append status=none conv=notrunc skip=32620046 count=1382
dd if=plug.dat of=plug5.dat iflag=skip_bytes,count_bytes oflag=append status=none conv=notrunc skip=18203136 count=11769
dd if=plug.dat of=plug5.dat iflag=skip_bytes,count_bytes oflag=append status=none conv=notrunc skip=32621428 count=205
dd if=plug.dat of=plug5.dat iflag=skip_bytes,count_bytes oflag=append status=none conv=notrunc skip=18430720 count=11545
dd if=plug.dat of=plug5.dat iflag=skip_bytes,count_bytes oflag=append status=none conv=notrunc skip=32621633 count=26
dd if=plug.dat of=plug5.dat iflag=skip_bytes,count_bytes oflag=append status=none conv=notrunc skip=18214912 count=36349
dd if=plug.dat of=plug5.dat iflag=skip_bytes,count_bytes oflag=append status=none conv=notrunc skip=32621659 count=116
dd if=plug.dat of=plug5.dat iflag=skip_bytes,count_bytes oflag=append status=none conv=notrunc skip=18401792 count=27397
dd if=plug.dat of=plug5.dat iflag=skip_bytes,count_bytes oflag=append status=none conv=notrunc skip=32621775 count=2279
dd if=plug.dat of=plug5.dat iflag=skip_bytes,count_bytes oflag=append status=none conv=notrunc skip=18444544 count=573288
dd if=plug.dat of=plug5.dat iflag=skip_bytes,count_bytes oflag=append status=none conv=notrunc skip=32624054 count=3005
dd if=plug.dat of=plug5.dat iflag=skip_bytes,count_bytes oflag=append status=none conv=notrunc skip=19017984 count=1039801
dd if=plug.dat of=plug5.dat iflag=skip_bytes,count_bytes oflag=append status=none conv=notrunc skip=32627059 count=199685
dd if=plug.dat of=plug5.dat iflag=skip_bytes,count_bytes oflag=append status=none conv=notrunc skip=20814848 count=5520
dd if=plug.dat of=plug5.dat iflag=skip_bytes,count_bytes oflag=append status=none conv=notrunc skip=32826744 count=13744
dd if=plug.dat of=plug5.dat iflag=skip_bytes,count_bytes oflag=append status=none conv=notrunc skip=22939904 count=1373199
dd if=plug.dat of=plug5.dat iflag=skip_bytes,count_bytes oflag=append status=none conv=notrunc skip=32840488 count=1361
dd if=plug.dat of=plug5.dat iflag=skip_bytes,count_bytes oflag=append status=none conv=notrunc skip=20822272 count=2114479
dd if=plug.dat of=plug5.dat iflag=skip_bytes,count_bytes oflag=append status=none conv=notrunc skip=32841849 count=753
dd if=plug.dat of=plug5.dat iflag=skip_bytes,count_bytes oflag=append status=none conv=notrunc skip=24313856 count=1372976
dd if=plug.dat of=plug5.dat iflag=skip_bytes,count_bytes oflag=append status=none conv=notrunc skip=32842602 count=13688
dd if=plug.dat of=plug5.dat iflag=skip_bytes,count_bytes oflag=append status=none conv=notrunc skip=25701888 count=11664
dd if=plug.dat of=plug5.dat iflag=skip_bytes,count_bytes oflag=append status=none conv=notrunc skip=32856290 count=3832
dd if=plug.dat of=plug5.dat iflag=skip_bytes,count_bytes oflag=append status=none conv=notrunc skip=25717504 count=27264
dd if=plug.dat of=plug5.dat iflag=skip_bytes,count_bytes oflag=append status=none conv=notrunc skip=32860122 count=1024
dd if=plug.dat of=plug5.dat iflag=skip_bytes,count_bytes oflag=append status=none conv=notrunc skip=25777408 count=11156
dd if=plug.dat of=plug5.dat iflag=skip_bytes,count_bytes oflag=append status=none conv=notrunc skip=32861146 count=668
dd if=plug.dat of=plug5.dat iflag=skip_bytes,count_bytes oflag=append status=none conv=notrunc skip=25789184 count=32664
dd if=plug.dat of=plug5.dat iflag=skip_bytes,count_bytes oflag=append status=none conv=notrunc skip=32861814 count=384
dd if=plug.dat of=plug5.dat iflag=skip_bytes,count_bytes oflag=append status=none conv=notrunc skip=25745152 count=31368
dd if=plug.dat of=plug5.dat iflag=skip_bytes,count_bytes oflag=append status=none conv=notrunc skip=32862198 count=826936
dd if=plug.dat of=plug5.dat iflag=skip_bytes,count_bytes oflag=append status=none conv=notrunc skip=26609920 count=11768
dd if=plug.dat of=plug5.dat iflag=skip_bytes,count_bytes oflag=append status=none conv=notrunc skip=33689134 count=2152
md5sum plug5.dat | grep f695ba887c12e2da27109ad7240e86ea > /dev/null || echo plugin database corrupt

# Determine the processor type.
PROCESSOR_TYPE=`uname -m`
if [ "$PROCESSOR_TYPE" = "x86_64" ]; then
	PLUG_STANDALONE="plug1.dat"
	PLUG_CLAP="plug2.dat"
elif [ "$PROCESSOR_TYPE" = "aarch64" ]; then
	PLUG_STANDALONE="plug4.dat"
	PLUG_CLAP="plug5.dat"
else
	echo "Unsupported processor architecture." && exit 1
fi

# Make the plugin executable.
chmod +x $PLUG_CLAP

# Check for common errors.
whoami | grep root > /dev/null    && echo "This script should not be run as root." && exit 1
! which zenity > /dev/null        && echo "Missing required dependency 'zenity'."  && exit 1
ldd $PLUG_CLAP | grep "not found" && echo "Missing required library dependency."   && exit 1

# Decide where to install.
clap_dir=$(echo "$CLAP_PATH" | sed 's/:.*//')
clap_dir=${clap_dir:-$HOME/.clap}

# Install the standalone application.
if [ -f $PLUG_STANDALONE ]; then
	echo "Installing the standalone application to $HOME/.local/share"
	mkdir -p "$HOME/.local/share/nakst"
	mkdir -p "$HOME/.local/share/applications"
	chmod +x $PLUG_STANDALONE
	mv $PLUG_STANDALONE "$HOME/.local/share/nakst/$PLUGIN"
	mv plug3.dat "$HOME/.local/share/applications/$PLUGIN.desktop"
	printf "Name=$PLUGIN\n" >> "$HOME/.local/share/applications/$PLUGIN.desktop"
	printf "Exec=$HOME/.local/share/nakst/$PLUGIN\n" >> "$HOME/.local/share/applications/$PLUGIN.desktop"
fi

# Install the CLAP plugin.
echo "Installing the CLAP plugin to $clap_dir/nakst/$PLUGIN.clap"
mkdir -p "$clap_dir/nakst"
mv $PLUG_CLAP "$clap_dir/nakst/$PLUGIN.clap"

# Remove any unused files.
rm -f plug1.dat plug2.dat plug3.dat plug4.dat plug5.dat

cat ~/.config/NakstAudioPlugins.ini | grep HasAnyPaidPlugins || printf "\n[generic]\nHasAnyPaidPlugins=1\n" >> ~/.config/NakstAudioPlugins.ini
